#include common_scripts\utility;
#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;

init()
{
	level.doCustomMap = 0;
	level.doorwait = 2;
	level.FinalKillAttacker = 0;
	level.buildingMap = 1;
	if(getDvar("mapname") == "mp_boneyard"){ /** Scrapyard **/
		level Scrapyard();
		level.doCustomMap = 1;
	}
	else if(getDvar("mapname") == "mp_checkpoint"){ /** Karachi **/
		level Karachi();
		level.doCustomMap = 1;
	}
	else if(getDvar("mapname") == "mp_derail"){ /** Derail **/
		level Derail();
		level.doCustomMap = 1;
	}
	else if(getDvar("mapname") == "mp_highrise"){ /** HighRise **/
		level HighRise();
		level.doCustomMap = 1;
	}
	else if(getDvar("mapname") == "mp_nightshift"){ /** Skidrow **/
		level Skidrow();
		level.doCustomMap = 1;
	}
	else if(getDvar("mapname") == "mp_quarry"){ /** Quarry **/
		level Quarry();
		level.doCustomMap = 1;
	}
	else if(getDvar("mapname") == "mp_rust"){ /** Rust **/
		level Rust();
		level.doCustomMap = 1;
	}
	else if(getDvar("mapname") == "mp_terminal"){ /** Terminal **/
		level Terminal();
		level.doCustomMap = 1;
	}
	if(level.doCustomMap == 1)
	{
		level.gameState = "starting";
	}
	level.buildingMap = 0;
}

CreateGrids(corner1, corner2, angle)
{
	W = Distance((corner1[0], 0, 0), (corner2[0], 0, 0));
	L = Distance((0, corner1[1], 0), (0, corner2[1], 0));
	H = Distance((0, 0, corner1[2]), (0, 0, corner2[2]));
	CX = corner2[0] - corner1[0];
	CY = corner2[1] - corner1[1];
	CZ = corner2[2] - corner1[2];
	ROWS = roundUp(W/55);
	COLUMNS = roundUp(L/30);
	HEIGHT = roundUp(H/20);
	XA = CX/ROWS;
	YA = CY/COLUMNS;
	ZA = CZ/HEIGHT;
	center = spawn("script_model", corner1);
	for(r = 0; r <= ROWS; r++){
		for(c = 0; c <= COLUMNS; c++){
			for(h = 0; h <= HEIGHT; h++){
				block = spawn("script_model", (corner1 + (XA * r, YA * c, ZA * h)));
				block setModel("com_plasticcase_friendly");
				block.angles = (0, 0, 0);
				block Solid();
				block.health = level.blockHealth;
				block thread crateManageHealth();
				block LinkTo(center);
				block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
				block thread waitToDestroy();
				level.blockSpawn[level.blocks] = block.origin;
				level.blockEntity[level.blocks] = block;
				level.blocks++;
			}
		}
	}
	center.angles = angle;
}

CreateLowerGrids(corner1, corner2, angle)
{
	W = Distance((corner1[0], 0, 0), (corner2[0], 0, 0));
	L = Distance((0, corner1[1], 0), (0, corner2[1], 0));
	H = Distance((0, 0, corner1[2]), (0, 0, corner2[2]));
	CX = corner2[0] - corner1[0];
	CY = corner2[1] - corner1[1];
	CZ = corner2[2] - corner1[2];
	ROWS = roundUp(W/55);
	COLUMNS = roundUp(L/30);
	HEIGHT = roundUp(H/20);
	XA = CX/ROWS;
	YA = CY/COLUMNS;
	ZA = CZ/HEIGHT;
	center = spawn("script_model", corner1);
	for(r = 0; r <= ROWS; r++){
		for(c = 0; c <= COLUMNS; c++){
			for(h = 0; h <= HEIGHT; h++){
				block = spawn("script_model", (corner1 + (XA * r, YA * c, ZA * h)));
				block setModel("com_plasticcase_friendly");
				block.angles = (0, 0, 0);
				block Solid();
				block.health = level.blockHealth;
				block thread crateManageHealth();
				block LinkTo(center);
				block CloneBrushmodelToScriptmodel( level.airDropCrateCollision );
				block thread waitToDestroy();
				level.blockEntity[level.blocks] = block;
				level.blocks++;
			}
		}
	}
	center.angles = angle;
}

waitToDestroy(){
	self endon("destroyed");
	level waittill("round_reset");
	self delete();
	self notify("destroyed");
}

crateManageHealth()
{
	self endon("destroyed");
	self setcandamage(true);
    self.team = level.host.team;
    self.owner = level.host.owner;
    self.pers["team"] = level.host.team;
    while(self)
    {
		self waittill( "damage", eInflictor, attacker, victim, iDamage, sMeansOfDeath, sWeapon, vDir, sHitLoc, psOffsetTime, deathAnimDuration, isFauxDeath );
		//iPrintLn("MOD_GRENADE_SPLASH == " + sMeansOfDeath);
		if(sMeansOfDeath == "MOD_GRENADE_SPLASH"){
			attacker notify("grenade_explode");
			//RadiusDamage( self.origin, 100, 100, 10);
		}
        if(self.health <= 0)
        {
			level.FinalKillAttacker = attacker;
			level.FinalKillerEntity = attacker getEntityNumber();
            playfx(level.customFX["fire_ball"], self.origin);
			self playSound( "h1_briefcase_exp_mid" );
			//RadiusDamage( self.origin, 70, 15, 10);
            self delete();
			self notify("destroyed");
		}
		wait 0.1;
    }
}


roundUp( floatVal )
{
	if ( int( floatVal ) != floatVal )
		return int( floatVal+1 );
	else
		return int( floatVal );
}

Terminal()
{
   CreateGrids((2726, -754, 1000), (2000, -1500, 1000), (0, 0, 0));
}

Rust()
{
   CreateGrids((2726, -754, 1000), (1800, -1800, 1000), (0, 0, 0));
}

Scrapyard()
{
   CreateGrids((2726, -754, 1000), (2300, -1300, 1000), (0, 0, 0));
   CreateLowerGrids((2726, -754, 850), (2300, -1300, 850), (0, 0, 0));
}

Karachi()
{
   CreateGrids((2726, -754, 1000), (2100, -1500, 1000), (0, 0, 0)); //
}

Derail()
{
   CreateGrids((2600, -754, 1500), (1800, -1800, 1500), (0, 0, 0));
}

Highrise()
{
   CreateGrids((-1400,3000,5555), (-1000,3500,5555), (0, 0, 0));
   CreateLowerGrids((-1400,3000,5355), (-1000,3500,5355), (0, 0, 0));
}

Skidrow()
{
   CreateGrids((2726, -754, 1000), (2000, -1500, 1000), (0, 0, 0));  //
}

Quarry()
{
   CreateGrids((-2500,2000,2000), (-3100,1500,2000), (0, 0, 0));  
}